<?php if (!defined('VB_ENTRY')) die('Access denied.');

/*======================================================*\
|| ############################################### ||
|| # ----------------vBSmart Team - vBulletin 4.0.1Version ------------------------- # ||
|| # Copyright 2000-2010 vBulletin Solutions Inc. All Rights Reserved. ||
|| #      This file may not be redistributed in whole or significant part    . # ||
|| ############################################### ||
\*======================================================*/

/**
 * @package vBulletin
 * @subpackage Search
 * @author Ed Brown, vBulletin Development Team
 * @version $Id: article.php 30550 2009-04-28 23:55:20Z ebrown $
 * @since $Date: 2009-04-28 16:55:20 -0700 (Tue, 28 Apr 2009) $
 * @copyright vBulletin Solutions Inc.
 */

require_once (DIR . '/vb/search/result.php');
include_once DIR . '/packages/vbcms/item/content/article.php';
require_once (DIR . '/vb/search/indexcontroller/null.php');
/**
 * Result Implementation for CMS Article
 *
 * @see vB_Search_Result
 * @package vBulletin
 * @subpackage Search
 */
class vBCms_Search_Result_Article extends vB_Search_Result
{
	private $categories;

	private $tags;


	/**
	 * factory method to create a result object
	 *
	 * @param integer $id
	 * @return result object
	 */
	public static function create($id)
	{
		return self::create_array(array($id));
	}

	/**
	 * this will create an array of result objects from an array of ids()
	 *
	 * @param array of integer $ids
	 * @return array of objects
	 */
	public static function create_array($ids)
	{
		$contenttypeid = vb_Types::instance()->getContentTypeId('vBCms_Article');

		$rst = vB::$vbulletin->db->query_read("
			SELECT a.contentid as itemid,
				u.username, a.contentid, n.nodeid, u.userid, i.html_title, a.blogid, n.setpublish AS published,
				n.url, n.showtitle, n.showuser, n.showpreviewonly,
				n.showupdated, n.showviewcount, n.settingsforboth,
				a.pagetext, i.title, i.description, n.publishdate, parent.title as parenttitle, i.viewcount,
				n.parentnode as parentid, a.threadid, a.postauthor, a.poststarter, a.blogpostid, a.previewtext,
				a.postid, a.post_started, a.post_posted, thread.threadid AS comment_threadid , thread.title AS threadtitle, thread.replycount,
				thread.lastposterid, thread.lastposter, thread.dateline, thread.views, thread.lastpost
			FROM " . TABLE_PREFIX . "cms_article a
				LEFT JOIN " . TABLE_PREFIX . "cms_node n ON n.contentid = a.contentid
  			LEFT JOIN " . TABLE_PREFIX . "cms_nodeinfo i ON i.nodeid = n.nodeid
  			LEFT JOIN " . TABLE_PREFIX . "cms_nodeinfo AS parent ON parent.nodeid = n.parentnode
  			LEFT JOIN " . TABLE_PREFIX . "thread AS thread ON thread.threadid = i.associatedthreadid
  			LEFT JOIN " . TABLE_PREFIX . "user u ON u.userid = n.userid
			WHERE a.contentid IN (" . implode(', ', $ids) .") AND n.contenttypeid = " . $contenttypeid
		);

		$id_list = array();
		$items = array();

		if ($rst)
		{
			$bbcode_parser = new vBCms_BBCode_HTML(vB::$vbulletin, vBCms_BBCode_HTML::fetchCmsTags());
			$bbcode_parser->setOutputPage(1);
			while ($search_result = vB::$vbulletin->db->fetch_array($rst))
			{
				//If unpublished we hide this.
				if (!($search_result['publishdate'] < TIMENOW))
				{
					continue;
				}
				$item = new vBCms_Search_Result_Article();
				$item->itemid = $search_result['itemid'];
				$categories = array();
				$tags = array();
				$item->contenttypeid = $contenttypeid;
				$search_result['pagetext'] = $bbcode_parser->do_parse($search_result['pagetext'], true);
				$search_result['categories'] = $categories;
				$item->record = $search_result;
				$id_list[$search_result['nodeid']] = $search_result['itemid'];
				$items[$search_result['itemid']] = $item;
			}

			//avoid database error when all cms items are filtered out.
			if (!count($id_list))
			{
				return array();
			}

			$ids = implode(', ', array_keys($id_list));
			$rst1 = vB::$vbulletin->db->query_read(
				"SELECT cat.categoryid, cat.category, nc.nodeid FROM " .
				TABLE_PREFIX . "cms_nodecategory AS nc INNER JOIN " .	TABLE_PREFIX .
				"cms_category AS cat ON nc.categoryid = cat.categoryid WHERE nc.nodeid IN ($ids)"
			);

			if ($rst1)
			{
				$route = new vBCms_Route_List();
				$route->setParameter('action', 'list');

				while($record = vB::$vbulletin->db->fetch_array($rst1))
				{
					$itemid = $id_list[$record['nodeid']];
					$record['category_url'] = vBCms_Route_List::getUrl(array('type' =>'category', 'value' => $record['categoryid'], 'page' => 1));
					$items[$itemid]->addCategory($record['categoryid'], $record)  ;
				}
			}

			if ($rst1 = vB::$vbulletin->db->query_read("SELECT tag.tagid, tag.tagtext, node.contentid FROM " .
				TABLE_PREFIX . "cms_node AS node INNER JOIN " .	TABLE_PREFIX .
				"tagcontent AS tc ON (tc.contentid = node.contentid AND  tc.contenttypeid = node.contenttypeid)
				INNER JOIN " .	TABLE_PREFIX .
				"tag AS tag ON tag.tagid = tc.tagid
				 WHERE node.nodeid IN ($ids) " ))
			{
				while($record = vB::$vbulletin->db->fetch_array($rst1))
				{
					$items[$record['contentid']]->addTag($record['tagid'], $record);
			}
			}
			return $items;
		}
		return false;
	}

	/**
	 * protected constructor, to ensure use of create()
	 *
	 */
	protected function __construct()
	{}

	/**
	 * all result objects must tell their contenttypeid
	 *
	 * @return integer contenttypeid
	 */
	public function get_contenttype()
	{

		return isset($this->contenttypeid) ?
			$this->contenttypeid :
			vB_Types::instance()->getContentTypeID("vBCms_Article");
	}

	/**
	 * all result objects must tell whether they are searchable
	 *
	 * @param mixed $user: the id of the user requesting access
	 * @return bool true
	 */
	public function can_search($user)
	{
	//By definition, an article is always searchable, even
	// for a guest.
		return true;
	}

	public function get_record()
	{
		return $this->record;
	}

	/**
	 * function to return the rendered html for this result
	 *
	 * @param string $current_user
	 * @param object $criteria
	 * @return
	 */
	public function render($current_user, $criteria, $template_name = '')
	{
		global $vbulletin;
		global $show;
		require_once DIR . '/vb/search/searchtools.php';
		require_once DIR . "/includes/functions_user.php";

		if (!strlen($template_name))
		{
			$template_name = 'vbcms_searchresult_article_general';
		}
		$template = vB_Template::create($template_name);

		$template->register('title', $this->record['title'] );
		$template->register('html_title', $this->record['html_title'] );
		$template->register('page_url', vB_Route::create('vBCms_Route_Content', $this->record['nodeid'] .
			($this->record['url'] == '' ? '' : '-' . $this->record['url'] )	)->getCurrentURL());
		$template->register('username', $this->record['username']);
		$template->register('description', $this->record['description']);
		$template->register('parenttitle' , $this->record['parenttitle'] );
		$template->register('parentid' , $this->record['parentid'] );
		$template->register('threadid' , $this->record['threadid'] );
		$template->register('postauthor' , $this->record['postauthor'] );
		$template->register('poststarter' , $this->record['poststarter'] );
		$template->register('blogpostid' , $this->record['blogpostid'] );
		$template->register('parentnode' , $this->record['parentnode'] );
		$template->register('postid' , $this->record['postid'] );
		$template->register('post_started' , $this->record['post_started'] );
		$template->register('post_posted' , $this->record['post_posted'] );
		$template->register('previewtext',$this->record['previewtext']);
		$template->register('pagetext',$this->record['pagetext']);
		$template->register('publish_phrase', ($this->record['publishdate'] ?
			$vbphrase['page_published'] : $vbphrase['page_unpublished']) );
		$template->register('author_phrase', 'author');
		$template->register('published', ($this->record['publishdate'] ?
			true : false));
		$template->register('categories', $this->categories);
		$template->register('tags', $this->tags);
		$template->register('article', $this->record);
		$template->register('dateline', date($vbulletin->options['dateformat']. ' '
			. $vbulletin->options['default_timeformat'], $this->record['publishdate']));
		$template->register('dateformat', $vbulletin->options['dateformat']);
		$template->register('timeformat', $vbulletin->options['default_timeformat']);
		$user = vB_Legacy_User::createFromId($this->record['userid']);

		//get the avatar
		if (intval($this->record['userid']))
		{
			$avatar = fetch_avatar_url($this->record['userid'],true);
		}

		if (!isset($avatar) OR (count($avatar) < 2))
		{
			$avatar = false;
		}
		$template->register('avatar', $avatar);
		$result = $template->render();

		return $result;
	}

	public function getCategories()
	{
		return $this->categories;
	}

	public function getTags()
	{
		return $this->tags;
	}

	public function addCategory($categoryid, $category)
	{
		$this->categories[$categoryid] = $category;
	}

	public function addTag($tagid, $tag)
	{
		$this->tags[$tagid] = $tag;
	}

	private $itemid;
	private $record;

}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 17:48, Tue Jan 12th 2010
|| # SVN: $Revision: 30550 $
|| ####################################################################
\*======================================================================*/